#include <gc.h>

/******************************************************************************
*
*  Render_hello
*
*******************************************************************************
*  An example image.
*
*******************************************************************************
*  Usage:
*     Render_hello( TGC* gc );
*
*  Arguments:
*     gc - the graphics context being drawn on.
*
*  Returns:
*     bool completed - true if the image could be drawn.
*                    - false if it can't be drawn.
*
*******************************************************************************
*/
//*** IMPORTANT: Image entry point naming convention ***
//
// The name of this function is created as follows:
//
//   - Take the name of this source file without the extension
//     and prepend "Render_".
//
// Failure to follow this naming convention for the image entry point
// will prevent the generator from recognizing the file as an image.
//
bool Render_hello( TGC* gc )
{
  INT32 w, h, x, y, strPixelWidth;

  //*** Indicate that there are no alternate image renditions
  gc->Versions( 0 );

  //*** Setup the lookup table:
  //    Black, white and some basic colors
  gc->SetLut( BW | HUERGB );

  //*** Clear the active screen area
  gc->ZeroActive();                 

  //*** Draw a white line from the top-left corner of the active area to
  //*** the bottom-right corner.
  //*** Also draw a border (rectangle) around the active screen area.
  //*** The TGC instance we are given has its various parameters pre-configured
  //*** by the generator based on the current in-use format.
  gc->Opaque( TStdColor::white, TStdColor::black );
  gc->DrawLine( gc->left, gc->top, gc->width, gc->height );
  gc->DrawRect( gc->width, gc->height, gc->left, gc->top );

  //--------------------------------------------------------
  // Draw a red filled oval centered on the screen
  //--------------------------------------------------------

  //*** Calculate the oval dimensions and position
  w = gc->width / 2;
  h = gc->height / 2;
  x = gc->centerleft - w/2;
  y = gc->centertop - h/2;

  //*** Select the color
  gc->Transparent( TStdColor::red );

  //*** Render the oval
  gc->FillOval( w, h, x, y );

  //--------------------------------------------------------
  // Render some text centered in the middle of the screen
  // and draw a line under the string.
  //--------------------------------------------------------

  //*** Create the desired text string
  const char* txt = "Hello World!";

  //*** Select the desired font and color (black)
  gc->SelectFont( "SYS16" );
  gc->Transparent( TStdColor::black );

  //*** Calculate the location of the string
  strPixelWidth = gc->GetWidth( txt );   // The width of the string in pixels
  x = (gc->width - strPixelWidth) / 2;
  y = (gc->height - gc->CharHigh()) / 2;

  //*** Draw the string
  gc->DrawString( x, y, txt );

  //*** Draw the underline
  gc->DrawLine( x, y + gc->GetDescent(), x + strPixelWidth, y + gc->GetDescent() );

  //*** Return "true" to indicate success.
  return true;
}



